/*jshint unused: vars */

define(["lib/Zoot",
		"lib/dev", "lib/tasks"
	], 
function (Z,
		dev, tasks
	) {
	"use strict";

	return {
		about: "$$$/private/animal/Behavior/HandleFixer/About=HandleFixer, (c) 2014.",
		description: "$$$/animal/Behavior/HandleFixer/Desc=Holds ^[Fixed^] handles in place",
		uiName: 	"$$$/animal/Behavior/HandleFixer/UIName=Handle Fixer",
		defaultArmedForRecordOn: true,
		defaultHideInTrackItemProperties: true,
	
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{
					id		: "targets",
					type	: "handle",
					uiName	: "$$$/animal/Behavior/HandleFixer/Parameter/targets=Target Handles",
					dephault: { match: "//Adobe.HandleFixer.Fixed" }
				}
			];
		},
		
		defineTags: function () {
			return { 
				aTags: [
					{
						id: "Adobe.HandleFixer.Fixed",
						artMatches: ["fixed"],
						uiName: "$$$/animal/Behavior/HandleFixer/UIName/Fixed=Fixed",
						tagType: "handletag",
						uiGroups: [{ id:"Adobe.TagGroup.Modifiers"}]									
					}
				]
			};
		},

		onCreateBackStageBehavior: function (self) {
			// execute first to prevent automating these vertices
			return { order: 0.0, importance : 0.0 };
		},
		
		onCreateStageBehavior: function (self, args) {
			self.aHandleTarget = args.getStaticParam("targets");
		},
		
		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			self.aHandleTarget.forEach(function (h) {
				tasks.handle.setFrame(h, Z.Mat3.identity(), tasks.dofs.type.kAffine);
			});
		}
			
	}; // end of object being returned
});
